### Data set description:

**Twitter**: download from  https://github.com/fe6Bc5R4JvLkFkSeExHM/k-center
               We use the first 30k rows and the 2 and 3 columns (longitude and latitude)

**Adult**: download from  https://archive.ics.uci.edu/ml/datasets/adult
            We use all the 32k rows and the 1,3,5,11,12,13 columns (all the number columns)

To test the above datasets, first set the right number of demands and dimensions in all files.
The format of input is a $N \times dim$ matrix, each row represents a point in dimension $dim$

**US-Grid**: download from  http://networkrepository.com

​                We preprocess the shortest path between all pairs $(x,y)$

The format of input is a $N(N-1)/2 \times 3$ matrix, each row $(x,y,z)$ represents the 

shortest path from $x$ to $y$  is $z$ .  If $x$ and $y$ are not connected, $z$ should be  a large enough number.

**Non-uni**: download from https://www.sciencedirect.com/science/article/pii/S2352340918300118

​                 We choose the pa dataset and use all the 4k points and the longitude,latitude and

​                 residential population columns.

The format of input is a $N \times (dim + 1)$ matrix, each row represents a point in dimension $dim$

and its opening cost.

### Code description 

In uniform case, we provide:
**MP.cpp**: the algorithm to find a near optimal solution and output open facilities.
**Meyerson.cpp**: one of the baselines, output the total cost. 
**Ours.cpp**: Our algorithm, take as input the metric and predictions and output total cost.
          It will also output another baseline follow-predict.
**gen.cpp**: change the order of demands and generate the prediction with error.

You can do the following step to verify our algorithm:
0. Make sure the facility cost and number of demands in all files are the same.
1. Run MP.cpp to get near optimal solution.
2. Set the error parameter and run gen.cpp to get the predictions and the order of input.
3. Run Meyerson.cpp to get the total cost by Meyerson algorithm. 
4. Run Ours.cpp to get the total cost by Our algorithm and follow-predict algorithm

In non-uniform case, we provide:
**MP.cpp**: the algorithm to find a near optimal solution and output open facilities.
        It will also generate the prediction with error.
**Meyerson.cpp**: one of the baselines, output the total cost. 
**Ours.cpp**: Our algorithm, take as input the metric and predictions and output total cost.
          It will also output another baseline follow-predict.

You can do the following step to verify our algorithm:
0. Make sure the facility cost and number of demands in all files are the same.
1. Set the error parameter and run MP.cpp to get near optimal solution and generate prediction with 
   error
2. Run Meyerson.cpp to get the total cost by Meyerson algorithm.
3. Run Ours.cpp to get the total cost by Our algorithm and follow-predict algorithm

We also provide a generate algorithm to construct the predictions using the past data.

**Predictor.cpp**: use the past data to construct a prediction sequence.

You can do the following step to use our algorithm:

0. Make sure the facility cost and number of demands in all files are the same.
1. Run Predictor.cpp to get the predictions of test data.
